PACKAGE composite_res IS
  TYPE xtype IS
    RECORD
      addr : INTEGER;
      data : INTEGER;
    END RECORD;

  TYPE xtypevector IS ARRAY( natural RANGE <>) OF xtype;
  CONSTANT notdriven : xtype := (-1,-1);

  FUNCTION cresolve( t : xtypevector) RETURN xtype;
END composite_res;

PACKAGE BODY composite_res IS
  FUNCTION cresolve( t : xtypevector) RETURN xtype IS
    VARIABLE result : xtype := notdriven;
    VARIABLE drive_count : INTEGER := 0;
  BEGIN
    IF t'LENGTH = 0 THEN RETURN notdriven;
    END IF;

    FOR i IN t'RANGE LOOP
      IF t(i) /= notdriven THEN
        drive_count := drive_count + 1;
        IF drive_count = 1 THEN
          result := t(i);
        ELSE
          result := notdriven;
          ASSERT FALSE 
            REPORT "multiple drivers detected"
            SEVERITY ERROR;
        END IF;
      END IF;
    END LOOP;
    RETURN result;
  END cresolve;
END composite_res;

